package tests;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JPanel;

import view.ComparisonsPanel;
import view.NPanel;
import view.TimesPanel;
import model.Execution;
import model.IExecution;
import model.ProxyExecution;

/**
 * Test Finale
 * 
 * @author koelio
 * 
 */
public class Test3 {

	private static JFrame frame;

	public static Frame getFrame() {
		// TODO Auto-generated method stub
		return frame;
	}

	public static void main(String[] args) {

		Test3.frame = new JFrame();
		frame.setTitle("Test3");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(300, 600);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation((int) (dim.getWidth() - frame.getWidth()) / 2,
				(int) (dim.getHeight() - frame.getHeight()) / 2);

		JPanel panel = new JPanel();
		frame.getContentPane().add(panel);
		panel.setLayout(new BorderLayout());

		IExecution execution = new Execution();
		ProxyExecution realexeExecution = new ProxyExecution(execution);
		
		NPanel nPanel = new NPanel(realexeExecution);
		ComparisonsPanel compPanel = new ComparisonsPanel(realexeExecution);
		TimesPanel timePane = new TimesPanel(realexeExecution);

		frame.setVisible(true);
		panel.add(nPanel, BorderLayout.NORTH);
		panel.add(compPanel, BorderLayout.CENTER);
		panel.add(timePane, BorderLayout.EAST);

	}
}
